$(function() {

	/* 禁止文本选择 */
	document.onselectstart = new Function("return false");
	document.ondragstart = new Function("return false");
	
	// 设置close-button的淡入淡出
	$('#confirm-close-button').append('<span class="hover"></span>').hover(function() {
	    view.fadeButtonIn.apply(this);
	}, function() {
		var el = this;
	    
		setTimeout(function() {
			if (!el.open) view.fadeButtonOut.apply(el);
		}, 10);
	}).click(function() {
		if(!$(this).is('.close-button-disabled')) {
			confirm.close(); // 关闭页面
		}
	}).mousedown(function() {
		this.className = 'close-button close-button-pressed';
		return false;
	}).mousedown(function() {
		this.className = 'close-button close-button-pressed';
		return false;
	}).mouseup(function() {
		this.className = 'close-button';
	}); 

	$('#confirm-cancel').click(function() {
		confirm.close(); // 关闭页面
	});
});

var confirm = {};
confirm.setTitle = function(title) {
	qqbrowser.dialog.setTitle(0, title);
};

confirm.setContent = function(content) {
	document.getElementById('confirm-text').innerHTML = content;
};

confirm.setConfirm = function(func) {
	document.getElementById('confirm-confirm').onclick = function() {
		func();
		confirm.close();
	};
};

confirm.setAlert = function() {
	$('#confirm-cancel').hide();

	document.getElementById('confirm-confirm').onclick = function() {
		confirm.close();
	};
};

confirm.close = function() {
	$('#confirm-popup').hide();
};

confirm.show = function() {
	$('#confirm-popup').show();
};